%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----------------------Error detection function---------------------------

function[error] = f_error(treatment_1, treatment_2, lower_interval, ...
    upper_interval, method, VA_trick, accuracy);

error = 0;
n_1 = numel(treatment_1);
n_2 = numel(treatment_2);

if n_2 > n_1;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('Treatment 1 has the be the one with higher number of observations!!!!!!!!!');
    disp('Please, run the code again labelling Treatment 1 as the treatment');
    disp('where you have higher number of observations');
    disp(' ');
    error = error + 1;
end;
if  isnumeric(treatment_1) == 0 | isreal(treatment_1) == 0;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The elements of the vector treatment_1 must be real numbers!!!!');
    disp(' ');
    error = error + 1;
elseif isnumeric(treatment_2) == 0 | isreal(treatment_2) == 0;;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The elements of the vector treatment_2 must be real numbers!!!!');
    disp(' ');
    error = error + 1;
end;
if sum(isnan(treatment_1)) > 0;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The vector treatment_1 can not have empty cells!!!!');
    disp(' ');
    error = error + 1;
end;
if sum(isnan(treatment_2)) > 0;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The vector treatment_2 can not have empty cells!!!!');
    disp(' ');
    error = error + 1;;
end;
if lower_interval > min(treatment_1) | lower_interval > min(treatment_2);     
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('Lower interval was incorrectly set!!!!');
    disp('It has to take the minimum theoretical possible value');
    disp(' ');
    error = error + 1;;
end;
if upper_interval < max(treatment_1) | upper_interval < max(treatment_2);
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('Upper interval was incorrectly set!!!!');
    disp('It has to take the maximum theoretical possible value');
    disp(' ');
    error = error + 1;;
end; 
if method ~= 0 & method ~= 1;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The variable "method" has to equal either 0 or 1!!!!!');
    disp(' ');
    error = error + 1;;
end;
if VA_trick ~= 0 & VA_trick ~= 1;
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The variable "VA_trick" has to equal either 0 or 1!!!!!');
    disp(' ');
    error = error + 1;;   
end;
if floor(accuracy/2) ~= ceil(accuracy/2);
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%----ERROR----%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
    disp('The variable "accuracy" has to be an even number!!!!!');
    disp(' ');
    error = error + 1;;
end;